IF EXISTS(SELECT * FROM sys.objects
			WHERE  object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_CPL_DEMANDA_PROC_MEDIAF]') AND type IN(N'P', N'PC')
)
DROP PROCEDURE [dbo].[P_EST_PROD_CPL_DEMANDA_PROC_MEDIAF];
GO
GO

CREATE PROCEDURE P_EST_PROD_CPL_DEMANDA_PROC_MEDIAF
AS
	 BEGIN
		 SET CONTEXT_INFO 0x66666;
		 PRINT 'Inicio do recalculo mediaF';
		 SET NOCOUNT ON;
	
/***********************************************************************************************************************/

		 DECLARE @CD_CTR_DEMANDA_PROC INT , @CD_EMP INT, @CD_FILIAL INT;
		 DECLARE @CONTADOR INT;
		 DECLARE @CD_CURVA_PD INT;
		 DECLARE @FLAG_PERFIL_LOJA INT;
		 DECLARE @FLAG_PERC_VARIACAO_DEMANDA_CONTROLE INT;

		 SET @CONTADOR = 0;
		 SET @CD_CURVA_PD =(SELECT CD_CURVA_PD FROM PRC_EMP WHERE  CD_EMP = 1);

/***********************************************************************************************************************/

		 CREATE TABLE #RsDemandaProc(CD_CTR_DEMANDA_PROC INT
									, CD_USU              INT
									, STS_PROC            INT
									);

		 CREATE TABLE #RsDemandaProcCplPendente(CD_CTR_DEMANDA_PROC INT);
		 CREATE TABLE #RsProcMediaFProcessamento(CD_CTR_PROC_CPL BIGINT);
		 
		 INSERT INTO #RsDemandaProc
		 SELECT
				EST_PROD_CPL_DEMANDA_PROC.CD_CTR
			  , EST_PROD_CPL_DEMANDA_PROC.CD_USU
			  , 1 AS STS_PROC
		 FROM
			 EST_PROD_CPL_DEMANDA_PROC
		 WHERE  EST_PROD_CPL_DEMANDA_PROC.DT_PROC <= GETDATE()
				AND EST_PROD_CPL_DEMANDA_PROC.STS_PROC IN(0, 2)
				AND EST_PROD_CPL_DEMANDA_PROC.TP_DEMANDA = 0 ;

		 CREATE UNIQUE CLUSTERED INDEX IX_#RsDemandaProc ON #RsDemandaProc(CD_CTR_DEMANDA_PROC);
		 CREATE UNIQUE CLUSTERED INDEX IX_#RsProcMediaFProcessamento ON #RsProcMediaFProcessamento(CD_CTR_PROC_CPL);	

		  
/***********************************************************************************************************************/
		 SET @FLAG_PERC_VARIACAO_DEMANDA_CONTROLE = ISNULL((SELECT VALOR FROM
															PRC_EMP_CONFIG
												WHERE  CD_EMP = @CD_EMP
													   AND CD_CHAVE = 'FLAG_PERC_VARIACAO_DEMANDA_CONTROLE'
											), 0);


--Processo so sera ativado para o cliente ativar o controle de 
--Perfil de loja e produto
		 SET @FLAG_PERFIL_LOJA = ISNULL((SELECT VALOR FROM
													PRC_EMP_CONFIG
												WHERE  CD_EMP = @CD_EMP
													   AND CD_CHAVE = 'FLAG_USA_PERFIL_FILIAL_PRODUTO'
											), 0);

		 IF @FLAG_PERFIL_LOJA = 1
			 BEGIN
				 CREATE TABLE #EstProdCplDemandaProcCpl(CD_CTR              INT
														, CD_EMP              INT
														, CD_FILIAL           INT
														, CD_PROD             INT
														, QTDE_DEMANDA        MONEY
														, BLQ                 INT
														, HISTORICO           VARCHAR(200)
														, CD_CTR_DEMANDA_PROC INT
														);
				 INSERT INTO #EstProdCplDemandaProcCpl
				 SELECT
						EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR
					  , EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP
					  , EST_PROD_CPL_DEMANDA_PROC_CPL.CD_FILIAL
					  , EST_PROD_CPL_DEMANDA_PROC_CPL.CD_PROD
					  , EST_PROD_CPL_DEMANDA_PROC_CPL.QTDE_DEMANDA
					  , 1 AS BLQ
					  , 'PRODUTO FORA DO PERFIL DA LOJA'
					  , EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC
				 FROM
					 EST_PROD_CPL_DEMANDA_PROC_CPL
					 LEFT OUTER JOIN V_EST_PARAM_COMPRAS_PERFIL_EST_PROD ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP = V_EST_PARAM_COMPRAS_PERFIL_EST_PROD.CD_EMP
																			AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_FILIAL = V_EST_PARAM_COMPRAS_PERFIL_EST_PROD.CD_FILIAL
																			AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_PROD = V_EST_PARAM_COMPRAS_PERFIL_EST_PROD.CD_PROD
				 WHERE  
					V_EST_PARAM_COMPRAS_PERFIL_EST_PROD.CD_PROD IS NULL;
				 
				 INSERT INTO EST_PROD_CPL_DEMANDA_PROC_CPL_NAO_PROCESSAR(
						CD_CTR_DEMANDA_PROC
					  , CD_EMP
					  , CD_FILIAL
					  , CD_PROD
					  , QTDE_DEMANDA
					  , TIPO_NAO_PROCESSAR
					  , HISTORICO_NAO_PROCESSAR)
				 SELECT
						CD_CTR_DEMANDA_PROC
					  , CD_EMP
					  , CD_FILIAL
					  , CD_PROD
					  , QTDE_DEMANDA
					  , BLQ
					  , HISTORICO
				 FROM
					 #EstProdCplDemandaProcCpl;
				 DELETE 
					EST_PROD_CPL_DEMANDA_PROC_CPL
				 FROM EST_PROD_CPL_DEMANDA_PROC_CPL
					  INNER JOIN #EstProdCplDemandaProcCpl P ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = P.CD_CTR;
				 DROP TABLE #EstProdCplDemandaProcCpl;
			 END;

/***********************************************************************************************************************/
		UPDATE    
			R
		SET
			R.CD_SIGLA = 0
		 FROM      
			EST_PROD_CPL_DEMANDA_PROC_CPL R
			INNER JOIN #RsDemandaProc P ON R.CD_CTR_DEMANDA_PROC = P.CD_CTR_DEMANDA_PROC
		 WHERE
			   R.CD_SIGLA IS NULL

		

		UPDATE    
			R
		SET
			   R.CD_SIGLA = isnull(CV.CD_SIGLA,@CD_CURVA_PD) 
		 FROM      
			EST_PROD_CPL_DEMANDA_PROC_CPL R
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON R.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP
			AND R.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD
			INNER JOIN #RsDemandaProc P ON R.CD_CTR_DEMANDA_PROC = P.CD_CTR_DEMANDA_PROC
			OUTER APPLY( SELECT TOP (1) CD_SIGLA 
												FROM
													V_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_FILIAL  a
												WHERE	
														a.CD_EMP = 1
													AND a.VLR_PARAMETRO <= R.QTDE_DEMANDA
													AND a.CD_FILIAL		   = R.CD_FILIAL
													AND a.CD_PROD			= EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD
													

												ORDER BY
													a.VLR_PARAMETRO DESC
											) CV
		 WHERE
			   R.CD_SIGLA = 0;

/***********************************************************************************************************************/

		 DECLARE ProcDemandaALL CURSOR FAST_FORWARD
		 FOR 
			SELECT DISTINCT
					EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC
				  , EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP
				  , EST_PROD_CPL_DEMANDA_PROC_CPL.CD_FILIAL
			 FROM
				 #RsDemandaProc p
				 INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL ON 
					p.CD_CTR_DEMANDA_PROC = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC
				 INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_PENDENTE_APLICAR_MEDIAF ON 
					EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_PENDENTE_APLICAR_MEDIAF.CD_CTR_PROC_CPL;


		 OPEN ProcDemandaALL;
		 FETCH NEXT FROM ProcDemandaALL INTO @CD_CTR_DEMANDA_PROC, @CD_EMP, @CD_FILIAL ;
		 WHILE @@FETCH_STATUS = 0
			 BEGIN

--------------------------------------------------------------------------------------------------------------------------------------		
				PRINT 'Demanda ctr '+CONVERT(VARCHAR(10), @CD_CTR_DEMANDA_PROC)
						+' '+' contador '+CONVERT(VARCHAR(10), @CONTADOR)
						+' '+ CONVERT(VARCHAR, GETDATE(), 108);
				PRINT '---------- Filial ----> ' +CONVERT(VARCHAR(10), @CD_FILIAL)		 
				
				IF @FLAG_PERC_VARIACAO_DEMANDA_CONTROLE =1
				BEGIN
					UPDATE EST_PROD_CPL_DEMANDA_PROC_CPL
					  SET
						  EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PARAMETRO = B.CD_CTR_DEMANDA_PARAMETRO
						, EST_PROD_CPL_DEMANDA_PROC_CPL.TP_NIVEL_PERC	 = B.TP_NIVEL_PERC
						, EST_PROD_CPL_DEMANDA_PROC_CPL.PERC_VARIACAO	 = B.PERC_VARIACAO
						, EST_PROD_CPL_DEMANDA_PROC_CPL.DS_PERC_VARIACAO = B.DS_PERC_VARIACAO
					FROM   EST_PROD_CPL_DEMANDA_PROC_CPL
						   LEFT OUTER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_LIB_PENDENTE ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_LIB_PENDENTE.CD_CTR_PROC_CPL
								    
						   CROSS APPLY UFD_EST_PROD_CPL_DEMANDA_PARAMETRO(EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP
																			, EST_PROD_CPL_DEMANDA_PROC_CPL.CD_FILIAL
																			, EST_PROD_CPL_DEMANDA_PROC_CPL.CD_PROD) B
					WHERE
						  EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC		= @CD_CTR_DEMANDA_PROC
						  AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP				= @CD_EMP
						  AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_FILIAL 			= @CD_FILIAL 
						  AND EST_PROD_CPL_DEMANDA_PROC_CPL_LIB_PENDENTE.CD_CTR_PROC_CPL IS NULL;		

				END
	--------------------------------------------------------------------------------------------------------------------------------------		

				PRINT 'Marcando a pendencia para aplicar no cadastro de produtos complemento	MEDIAF ' + CONVERT(VARCHAR, GETDATE(), 108);			
				INSERT INTO  #RsProcMediaFProcessamento(CD_CTR_PROC_CPL)
				SELECT
					EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR
				FROM
					EST_PROD_CPL_DEMANDA_PROC_CPL
					JOIN #RsDemandaProc p ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC = p.CD_CTR_DEMANDA_PROC

					LEFT OUTER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_LIB			ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_LIB.CD_CTR_PROC_CPL
					LEFT OUTER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_LIB_PENDENTE	ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_LIB_PENDENTE.CD_CTR_PROC_CPL					
					LEFT OUTER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_BLOQUEIO		ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_BLOQUEIO.CD_CTR_PROC_CPL
				WHERE  
					EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC		= @CD_CTR_DEMANDA_PROC
					AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP				= @CD_EMP
					AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_FILIAL 			= @CD_FILIAL 

					AND EST_PROD_CPL_DEMANDA_PROC_CPL_LIB.CD_CTR_PROC_CPL IS NULL
					AND EST_PROD_CPL_DEMANDA_PROC_CPL_BLOQUEIO.CD_CTR_PROC_CPL IS NULL
					AND EST_PROD_CPL_DEMANDA_PROC_CPL_LIB_PENDENTE.CD_CTR_PROC_CPL IS NULL;		

--------------------------------------------------------------------------------------------------------------------------------------		
		 
				
				PRINT 'Liberando prodtutos que nao possui percentual de variacao '+CONVERT(VARCHAR, GETDATE(), 108);

				INSERT INTO  EST_PROD_CPL_DEMANDA_PROC_CPL_LIB( CD_CTR_PROC_CPL
																	, CD_USU
																	, DT_CAD
																	, NM_PARAMETRO_ORIGEM
																	, PERC_VARIACAO
																	, CD_CTR_DEMANDA_PARAMETRO)
				SELECT
						EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR
						, p.CD_USU
						, GETDATE()
						, EST_PROD_CPL_DEMANDA_PROC_CPL.DS_PERC_VARIACAO
						, EST_PROD_CPL_DEMANDA_PROC_CPL.PERC_VARIACAO
						, CASE
							WHEN EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PARAMETRO = 0 THEN NULL
							ELSE EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PARAMETRO
						END
				FROM
					EST_PROD_CPL_DEMANDA_PROC_CPL
					LEFT OUTER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_LIB ON 
						EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_LIB.CD_CTR_PROC_CPL
					INNER JOIN #RsDemandaProc p ON 
						EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC = p.CD_CTR_DEMANDA_PROC
					LEFT OUTER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_BLOQUEIO ON 
						EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_BLOQUEIO.CD_CTR_PROC_CPL
					
					INNER JOIN #RsProcMediaFProcessamento pendMediaf ON  EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = pendMediaf.CD_CTR_PROC_CPL

				WHERE  
					(EST_PROD_CPL_DEMANDA_PROC_CPL.PERC_VARIACAO = 0
						OR (CASE WHEN EST_PROD_CPL_DEMANDA_PROC_CPL.QTDE_DEMANDA_ANTERIOR > 0 THEN
									((EST_PROD_CPL_DEMANDA_PROC_CPL.QTDE_DEMANDA - EST_PROD_CPL_DEMANDA_PROC_CPL.QTDE_DEMANDA_ANTERIOR) / EST_PROD_CPL_DEMANDA_PROC_CPL.QTDE_DEMANDA_ANTERIOR) * 100
								ELSE 0
							END) <= EST_PROD_CPL_DEMANDA_PROC_CPL.PERC_VARIACAO)

						AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC	= @CD_CTR_DEMANDA_PROC
						AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP				= @CD_EMP
						AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_FILIAL 			= @CD_FILIAL 
						AND EST_PROD_CPL_DEMANDA_PROC_CPL_LIB.CD_CTR_PROC_CPL IS NULL
						AND EST_PROD_CPL_DEMANDA_PROC_CPL_BLOQUEIO.CD_CTR_PROC_CPL IS NULL;

--------------------------------------------------------------------------------------------------------------------------------------		
				IF @FLAG_PERC_VARIACAO_DEMANDA_CONTROLE =1
				BEGIN
					--Liberando prodtutos que possui percentual de variacao acima do permitido 
					PRINT 'Liberando prodtutos que possui percentual de variacao acima do permitido '+CONVERT(VARCHAR, GETDATE(), 108);

					INSERT INTO   EST_PROD_CPL_DEMANDA_PROC_CPL_LIB_PENDENTE(
							CD_CTR_PROC_CPL
							, DT_CAD
							, NM_PARAMETRO_ORIGEM
							, PERC_VARIACAO
							, CD_CTR_DEMANDA_PARAMETRO)
					SELECT
							EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR
							, GETDATE()
							, EST_PROD_CPL_DEMANDA_PROC_CPL.DS_PERC_VARIACAO
							, EST_PROD_CPL_DEMANDA_PROC_CPL.PERC_VARIACAO
							, CASE
								WHEN EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PARAMETRO = 0 THEN NULL
								ELSE EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PARAMETRO
							END
					FROM
						EST_PROD_CPL_DEMANDA_PROC_CPL
						LEFT OUTER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_LIB ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_LIB.CD_CTR_PROC_CPL
						INNER JOIN #RsDemandaProc p ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC = p.CD_CTR_DEMANDA_PROC
						LEFT OUTER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_BLOQUEIO ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_BLOQUEIO.CD_CTR_PROC_CPL
						INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_PENDENTE_APLICAR_MEDIAF pendMediaf ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = pendMediaf.CD_CTR_PROC_CPL
					WHERE  (EST_PROD_CPL_DEMANDA_PROC_CPL.PERC_VARIACAO > 0
							OR (CASE WHEN EST_PROD_CPL_DEMANDA_PROC_CPL.QTDE_DEMANDA_ANTERIOR > 0 THEN
									((EST_PROD_CPL_DEMANDA_PROC_CPL.QTDE_DEMANDA - EST_PROD_CPL_DEMANDA_PROC_CPL.QTDE_DEMANDA_ANTERIOR) / EST_PROD_CPL_DEMANDA_PROC_CPL.QTDE_DEMANDA_ANTERIOR) * 100
									ELSE 0
								END) > EST_PROD_CPL_DEMANDA_PROC_CPL.PERC_VARIACAO)
							AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC	= @CD_CTR_DEMANDA_PROC
							AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP				= @CD_EMP
							AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_FILIAL 			= @CD_FILIAL 
							AND EST_PROD_CPL_DEMANDA_PROC_CPL_LIB.CD_CTR_PROC_CPL IS NULL
							AND EST_PROD_CPL_DEMANDA_PROC_CPL_BLOQUEIO.CD_CTR_PROC_CPL IS NULL;
				END				
--------------------------------------------------------------------------------------------------------------------------------------		
				--Alterando mediaF liberada
				PRINT 'Alterando mediaF liberada '+CONVERT(VARCHAR, GETDATE(), 108);

				UPDATE EST_PROD_CPL_MEDIAF
					SET
						QTDE_MEDIAF = EST_PROD_CPL_DEMANDA_PROC_CPL.QTDE_DEMANDA
					, CD_CTR_PROC_CPL_LIB = EST_PROD_CPL_DEMANDA_PROC_CPL_LIB.CD_CTR
					, CD_USU = P.CD_USU
					, DT_CAD = GETDATE()
					, QT_VD_ATUAL = EST_PROD_CPL_DEMANDA_PROC_CPL.QT_VD_ATUAL
					, QT_VD_MES1 = EST_PROD_CPL_DEMANDA_PROC_CPL.QT_VD_MES1
					, QT_VD_MES2 = EST_PROD_CPL_DEMANDA_PROC_CPL.QT_VD_MES2
					, QT_VD_MES3 = EST_PROD_CPL_DEMANDA_PROC_CPL.QT_VD_MES3
					, LIMITP = EST_PROD_CPL_DEMANDA_PROC_CPL.LIMITP
					, LIMITV = EST_PROD_CPL_DEMANDA_PROC_CPL.LIMITV
					, SAZ = EST_PROD_CPL_DEMANDA_PROC_CPL.SAZ
					, DT_NASC = EST_PROD_CPL_DEMANDA_PROC_CPL.DT_NASC
					, CD_SIGLA = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_SIGLA
				FROM   
					EST_PROD_CPL_MEDIAF
					INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL ON EST_PROD_CPL_MEDIAF.CD_EMP = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP
																	AND EST_PROD_CPL_MEDIAF.CD_FILIAL = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_FILIAL
																	AND EST_PROD_CPL_MEDIAF.CD_PROD = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_PROD
						
						INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_PENDENTE_APLICAR_MEDIAF pendMediaf ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = pendMediaf.CD_CTR_PROC_CPL

						INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_LIB ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_LIB.CD_CTR_PROC_CPL
						INNER JOIN #RsDemandaProc p ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC = p.CD_CTR_DEMANDA_PROC
				WHERE
						EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC	= @CD_CTR_DEMANDA_PROC
						AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_EMP			= @CD_EMP
						AND EST_PROD_CPL_DEMANDA_PROC_CPL.CD_FILIAL 		= @CD_FILIAL ; 

				TRUNCATE TABLE #RsProcMediaFProcessamento;
				SET @CONTADOR = @CONTADOR + 1;
				FETCH NEXT FROM ProcDemandaALL INTO @CD_CTR_DEMANDA_PROC
												, @CD_EMP
												, @CD_FILIAL;
		END;

	PRINT 'Concluido.';
	CLOSE ProcDemandaALL;
	DEALLOCATE ProcDemandaALL;

/***********************************************************************************************************************/

--Verificando se ainda existe pendencia de aplicacao de mediaF

		 INSERT INTO #RsDemandaProcCplPendente
		 SELECT DISTINCT
				EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC
		 FROM
			 #RsDemandaProc p
			 INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL ON p.CD_CTR_DEMANDA_PROC = EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR_DEMANDA_PROC
			 INNER JOIN EST_PROD_CPL_DEMANDA_PROC_CPL_PENDENTE_APLICAR_MEDIAF ON EST_PROD_CPL_DEMANDA_PROC_CPL.CD_CTR = EST_PROD_CPL_DEMANDA_PROC_CPL_PENDENTE_APLICAR_MEDIAF.CD_CTR_PROC_CPL;
		 
		 CREATE UNIQUE CLUSTERED INDEX IX_#RsDemandaProcCplPendente ON #RsDemandaProcCplPendente(CD_CTR_DEMANDA_PROC);

		 UPDATE #RsDemandaProc
		   SET
			   STS_PROC = 2
		 FROM   #RsDemandaProc p
				INNER JOIN #RsDemandaProcCplPendente pend ON p.CD_CTR_DEMANDA_PROC = pend.CD_CTR_DEMANDA_PROC;

/***********************************************************************************************************************/

--Indicando que o grupo de processamento ja 
	--analisou a variacao de media nova com a media anterior
	--1 - Nao existe pendencia
	--2 - Existe pendencia para analisar 

		 UPDATE EST_PROD_CPL_DEMANDA_PROC
		   SET
			   EST_PROD_CPL_DEMANDA_PROC.STS_PROC = p.STS_PROC
		 FROM   #RsDemandaProc P
				INNER JOIN EST_PROD_CPL_DEMANDA_PROC ON p.CD_CTR_DEMANDA_PROC = EST_PROD_CPL_DEMANDA_PROC.CD_CTR;
	 END;